<?php
/****************************************
 * XKLog 缓存管理函数库
 *
 * 此文件定义所有 cache_ 函数
 * 此文件改写自 JBlog
 *
 * 更新：2009-5-28
 * 版本：V1.0
 ****************************************/

!defined('IN_XKLOG') && exit('Access Denied!');

// 初始化缓存
function cache_initialize(){
	$cache_list = array( 'set','category','article_new','article_hot','comment_new','guestbook_new','link','menu','count','plugin','tag' );
	foreach ( $cache_list as $cache ){
		$cache_name = XKLOG_ROOT . './cache/cache_' . $cache . '.php';
		if ( !file_exists( $cache_name ) ){
			cache_load( $cache );
		}
	}
}

// 刷新缓存
function cache_load($cache_str = ''){
	if ( !$cache_str ){
		$cache_list = array( 'set','category','article_new','article_hot','comment_new','guestbook_new','link','menu','count','plugin','tag' );
	} else {
		$cache_list = explode( ',',$cache_str );
	}
	foreach ( $cache_list as $cache ){
		$cache_name = 'cache_' . $cache;
		if ( function_exists( $cache_name ) ){
			$cache_name();
		}
	}
}
// 缓存配置信息
function cache_set() {
	global $db;
	$content = array();
	$sql = 'select * from `' . PREFIX_STR . 'Set';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ){
		$content[] = $row;
	}
	write_to_file('set',$content);
}

// 缓存博客分类
function cache_category() {
	global $db;
	$content = array();
	$sql = 'SELECT CID,Name,Alias,ArticleNum,Description FROM `' . PREFIX_STR . 'Category` order by Num asc,CID desc';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ){
		$content[$row['CID']] = $row;
	}
	write_to_file('category',$content);
}

// 缓存最新文章
function cache_article_new() {
	global $db;
	$content = array();
	$sql = 'select `ID`,`Title`,`Type`,`Address`,`Category` from `' . PREFIX_STR . 'Article` where IsDel=0 order by ID desc limit 0,6';
	$content = $db->fetch_all($sql);
	write_to_file('article_new',$content);
}

// 缓存热门文章
function cache_article_hot() {
	global $db;
	$content = array();
	$sql = 'select ID,Title,Type,Address,Category from `' . PREFIX_STR . 'Article` where IsDel=0 order by Comment desc,`Read` desc limit 0,6';
	$query = $db->query($sql);
	while ( $row = $db->fetch_array($query) ) {
		$content[] = $row;
	}
	write_to_file('article_hot',$content);
}

// 缓存最新评论
function cache_comment_new() {
	global $db;
	$content = array();
	$sql = 'select C.Comment, C.ArticleID, A.Type, A.Address, A.Category, A.Title, C.Author from ' . PREFIX_STR . 'Comment as C, ' . PREFIX_STR . 'Article as A where C.ArticleID=A.ID and C.IsDel=0 and C.IsShow=1 and A.IsDel=0 AND C.ArticleID<>0 order by C.CID desc limit 0,6';
	$query = $db->query($sql);
	while ( $row = $db->fetch_array( $query ) ) {
		$content[] = $row;
	}
	write_to_file('comment_new',$content);
}

// 缓存最新留言
function cache_guestbook_new() {
	global $db;
	$content = array();
	$sql = 'select CID,Comment,Author from ' . PREFIX_STR . 'Comment where IsDel=0 and IsShow=1 AND ArticleID = 0 order by CID Desc limit 0,6';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ) {
		$content[] = $row;
	}
	write_to_file('guestbook_new',$content);
}

// 缓存友情链接
function cache_link() {
	global $db;
	$content = array();
	$sql = 'select Title,Description,Address from ' . PREFIX_STR . 'Link where IsDel=0 order by LID Asc';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ) {
		$content[] = $row;
	}
	write_to_file('link',$content);
}

// 缓存菜单项目
function cache_menu() {
	global $db;
	$content = array();
	$sql = 'select Name,Title,Type,Address from ' . PREFIX_STR . 'Menu order by Num Asc,MID Desc';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ) {
		$content[] = $row;
	}
	write_to_file('menu',$content);
}

// 缓存标签
function cache_tag() {
	global $db;
	$content = array();
	$sql = 'select * from ' . PREFIX_STR . 'Tags order by T_ID Asc';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ) {
		$content[$row['T_ID']] = $row;
	}
	write_to_file('tag',$content);
}

// 缓存统计信息
function cache_count() {
	global $db;
	$content = array();
	$content[] = array(
		'article_num' => $db->result( 'select count(ID) from ' . PREFIX_STR . 'Article where IsDel=False' ),
		'comment_num' => $db->result( 'select count(CID) from ' . PREFIX_STR . 'Comment where IsDel=False AND ArticleID<>0' ),
		'guestbook_num' => $db->result( 'select count(CID) from ' . PREFIX_STR . 'Comment where IsDel=False AND ArticleID=0' ),
		'user_num' => $db->result( 'select count(UID) from ' . PREFIX_STR . 'User where IsDel=False' ),
	);
	write_to_file('count',$content);
}

/*
// 缓存 Widget 项目
function cache_widget() {
	global $db;
	$content = array();
	$sql = 'select Name,Title,`Function` from ' . PREFIX_STR . 'Widget order by WID Desc';
	$query = $db->query( $sql );
	while ( $row = $db->fetch_array( $query ) ) {
		$content[] = $row;
	}
	write_to_file('widget',$content);
}

//缓存插件信息
function cache_plugin() {
	global $db;
	$content = array();
	$sql = "SELECT * FROM ".DB_TABLEPRE."plugin";
	$query = $db->query($sql);
	while ($row = $db->fetch_array($query)) {
		$content[$row['identifier']] = array('id' => $row['id'],'name' => $row['name'],'directory' => $row['directory'],'enabled' => $row['enabled'], 'runmode' => $row['runmode']);
		write_to_file('plugin_'.$row['id'], $row);
	}
	write_to_file('plugin',$content);
}
*/

// 生成缓存文件
function write_to_file($cache_name,$content = '') {
	if (is_array($content)) {
		$content = "\$_CACHE['$cache_name'] = ".var_export($content,True).';';
	}
	$content = "<?php\n//该文件是系统自动生成的缓存文件，请勿修改\n//创建时间：" . date('Y-m-d H:i:s',time()) . "\n\nif (!defined('IN_XKLOG')) {exit('Access Denied!');}\n\n".$content."\n\n?>";
	$file_name = XKLOG_ROOT . '/cache/cache_'.$cache_name.'.php';
	$len = file_put_contents($file_name, $content);
	@chmod($file_name, 0777);
	return $len;
}

// 刷新在线人数
function cache_online() {
	//$mtime = explode(' ',microtime());
	//$start_time = $mtime[0] + $mtime[1];
	global $db;
	$online = array();
	$online = $db->fetch_all( 'SELECT * FROM ' . PREFIX_STR . 'Online' );
	$now_time = time(); 
	$now_online = array();
	$user_login = false;
	// 在线有效时间，单位：秒 (即1200等于20分钟)
	$online_time = 1200;

	// 访问者 IP

	$user_ip = get_ip();


	// 得到仍然有效的数据
	foreach( $online as $row => $value ) {
		if( ( $now_time - $value['Time'] ) <= $online_time ) {
			$now_online[$row]['OID']  = $value['OID'];
			$now_online[$row]['IP']   = $value['IP'];
			$now_online[$row]['Time'] = $value['Time'];
			if( $value['IP'] == $user_ip ){
				$user_login = true;
			}
		} else {
			$db->query( 'DELETE FROM `' . PREFIX_STR . 'Online` WHERE OID = ' . $value['OID'] );
		}
	}

	$online_num = count( $now_online );

	if( $user_login ) {
		// 更新时间状态
		$db->query( "UPDATE `" . PREFIX_STR . "Online` SET Time = '$now_time' WHERE IP = '$user_ip'" );
	} else {
		// 初次访问
		$db->query( "INSERT INTO `" . PREFIX_STR . "Online` (`IP`,`Time`) VALUES ('$user_ip','$now_time')" );
		$db->query( "UPDATE `" . PREFIX_STR . "Set` SET VisitNum = VisitNum + 1,TodayNum = TodayNum  + 1" );
		$online_num ++;
	}

	//$mtime = explode(' ',microtime());
	//$stop_time = $mtime[0] + $mtime[1];
	//$run_time = number_format($stop_time - $start_time, 6);

	return $online_num;
}
?>